#### Application type
## Instruction
Please select "Contract Research > Outline Application" if your bid for a Contract Research project involves a multi application process. This will typically involve an initial draft bid/tender which may require basic details regarding costs for example, but which if "successful" will lead to a further more in depth bid. Susan Armstrong within RIO would be the best person to provide additional help should you require it, and will need to be involved in the contractual stage regardless.
## Example
Due to the nature of Contract Research projects it's unlikely there will be many occasions where a "Contract Research > Outline Application" will be required, however if there is a time where there are two or more discrete bid/tender rounds, then that's when the 'Outline Application' can be used. Typical Contract Research Clients could be Government Agencies or businesses.
#### Nature of activity type
## Instruction
Not being used currently, so please ignore.
## Example
n/a
#### Title
## Instruction
Please enter the full title of your Contract Research project.
## Example
n/a
#### Short title
## Instruction
Please enter the short title of your Contract Research project, if applicable.
## Example
n/a
#### Acronym
## Instruction
Please enter the acronym of your Contract Research project, if applicable.
## Example
n/a
#### Description
## Instruction
Please enter a short description of your Contract Research project, if applicable.
## Example
n/a
#### IPR/Confidentiality
## Instruction
Please enter a short description of any concerns regarding IPR/Confidentiality. If the field is left blank then that will be taken as a "none".
## Example
n/a
#### Conflict of interest
## Instruction
Please enter a short description of any concerns regarding Conflict of Interest. If the field is left blank then that will be taken as a "none".
## Example
n/a
#### IDs > Funder Reference
## Instruction
Please enter the client's reference for your project if known/applicable.
## Example
n/a
#### IDs > RIO ID
## Instruction
Please ignore this field - the RIO ID will be entered here by RIO once fully authorised.
## Example
n/a
#### IDs > Finance Account No.
## Instruction
Please ignore this field - the Finance Account No. will be entered here by Finance or RIO once fully authorised.
## Example
n/a
#### IDs > School Reference
## Instruction
Please ignore this field - your Research Advisor or equivalent will enter a reference here for their own records if applicable.
## Example
n/a
#### Related funding applicants
## Instruction
"PI and Co-Is are entered here, with their organisations populating as per the data held with PURE. The details entered here should match the applicants recorded on the application. Please use the ""Role"" dropdown to select each applicant's role of either ""PI"" or ""Co-I"".

If GCU are the lead applicant on an application with multiple applicants/collaborators, then please indicate the relevant GCU academic as the PI. If GCU are not the lead but are a Co-Applicant, then please enter the lead GCU academic first, but select their role as Co-I, followed by any other Co-Is. Please also include as PI, the external applicant who is the lead as per the application."
## Example
"If GCU are the lead and there are 3 external partners, then the GCU lead academic should be noted first and have a 'Role' of 'PI'. Any other GCU Co-Is should be noted also, and so too should the Co-Is from the 3 external partners - especially if the external partners are receiving funding.

If GCU are not the lead applicant, then as a minimum, the GCU lead academic should be recorded first with a 'Role' of 'Co-I'. Any other GCU applicants should be added at this point, and so too should the actual lead academic of the project. Although they are an external partner they should be given the 'Role' of 'PI' if this matches the application."
#### Managing organisational unit
## Instruction
Select the GCU lead academic's subject/department. This should be the first and potentially only item in the list.
## Example
The 'Managing organisational unit' is based on the lead GCU academic's subject/department e.g. History.
#### Collaborative application
## Instruction
Select "Yes" if there are applicants from multiple institutions and/or if there is another non applicant partner (industry partner for example). Selecting "No" will prevent the allocation of funds to other parties (institutions or partners) in the "Fundings" screen.
## Example
"Selecting ""yes"" will allow for additional organisations to be shown as applicants or partners, and this needs to be the case to allocate funds between all organisations applying.

If it is only GCU staff applying then ""No"" can be chosen, and no other organisation will be listed as part of the application."
#### Collaborators 
## Instruction
If "Yes" was selected in the "Collaborative application" field, then this is where collaborating organisations should be recorded. Applicants should be as per the application, with collaborators (but not applicants, e.g. industry partners) recorded as "project partners".
## Example
Other institutions or organisations would be shown here if applicable, e.g. King's College London if they were partnering with GCU on a Contract Research project.
#### Funding opportunity
## Instruction
Please ignore this field.
## Example
n/a
#### Fundings > Funding organisation
## Instruction
This field is for indicating the client, which is the organisation paying for the services of the GCU employee. More than one client can be entered if appropriate, so if there is funding from a 3rd party being contributed to this Contract Research project, then that 3rd party will need entered separately.
## Example
If the client on the Contract Research project is the Department for Environment, Food & Rural Affairs (DEFRA), then that's the funding body that should be noted here.
#### Fundings > Higher Education Statistics Agency (HESA) Types
## Instruction
"Please choose the relevant HESA Code for the funding body, with this info required for reporting purposes.

Further details can be found directly from the HESA site:
https://www.hesa.ac.uk/support/definitions/finances"
## Example
For example, if the client for whom you are carrying out the Contract Research is Stagecoach UK Bus (a Scottish based Bus Operator), then the correct HESA Code would be "UK industry, commerce and public corporations".
#### Fundings > REF income sources
## Instruction
Please ignore this field, it will update automatically based on the HESA Code entry when the application is saved.
## Example
n/a
#### Fundings > Funding organisation size
## Instruction
Please choose the appropriate size for the client.
## Example
For example, if the client to whom you are providing Consultancy services to is Stagecoach UK Bus (a Scottish based Bus Operator), then the correct organisation size is "Large Company".
#### Fundings > Funding organisation type
## Instruction
Please choose the appropriate location of the client.
## Example
For example, if the client to whom you are providing Consultancy services to is Stagecoach UK Bus (a Scottish based Bus Operator), then the correct organisation location is "Scotland Based".
#### Fundings > Funding project scheme (research programme)
## Instruction
Although not mandatory, it may be useful to enter the client's invite to tender here (or equivalent), if it exists. Later on there is the option to link to a web page from this application, so only the name would be required here.
## Example
For example, the title of the Contract Research opportunity/notice from Public Contracts Scotland or similar procurement service could be entered here.
#### Fundings > Cost code
## Instruction
*** To be hidden ***
## Example
n/a
#### Fundings > Financial summary > Financial
## Instruction
The default selection is "Financial" and this would only need changed if non-financial i.e. in-kind values/data was being entered. If a funder is providing both financial and non-financial support then they would need added as a funder twice - one for each type of support.
## Example
If an industry partner was contributing £1,000 to a project, then they would be included as a funder with this funding recorded. If they also were providing £500 of in-kind support (e.g. equipment usage), then they would be added as a funder again separately, the 'non-financial' button would need ticked, then the 'in-kind' contribution details would be added.
#### Fundings > Financial summary > Applied amount in applied currency
## Instruction
If the application/tender/contract is being completed in a currency other than GBP, please indicate the currency here and the amount in that currency being applied for.
## Example
If your application/tender/contract is being made to the European Commission then you'd enter the Euro equivalent figure and select the currency as "EUR - Euros". The GBP figure is required elsewhere.
#### Fundings > Financial summary > Applied amount
## Instruction
This field is for stating the total amount being applied for/requested (excluding VAT), i.e. the amount the funder would award to all applicants if successful. The value here may or may not match the  amount for GCU, but should match the amount on the application.
## Example
If the application/tender/contract is requesting £20,000, then despite GCU's Full Economic Cost potentially being higher; or despite GCU's share being potentially lower, £20,000 is still the 'Applied Amount'.
#### Fundings > Financial summary > Estimated value
## Instruction
This field is for stating the cash value of the 'in-kind' or otherwise non-financial contribution being requested.
## Example
If an industry partner was contributing £500 of in-kind support (e.g. equipment usage), then the value of £500 would be stated here.
#### Fundings > Financial summary > Description
## Instruction
This field is for providing details of the type of 'in-kind' or otherwise non-financial, contribution being requested.
## Example
If an industry partner was contributing £500 of in-kind support (e.g. equipment usage), then a description of the support would be required here.
#### Fundings > Split between the collaborative partners > Institutional part
## Instruction
This is the funding/income for GCU if the application/tender/contract is successful. funding/income for other partners is recorded elsewhere.
## Example
If GCU and another organisation are requesting £50,000 in total from a funder, but GCU's share is only £15,000, then it's this value, the £15,000, that's recorded in this field.
#### Fundings > Split between the collaborative partners > Institutional contribution
## Instruction
If GCU are contributing a specific set of funds to a project, then this would be entered here.
## Example
There are funding schemes which if successful in applying to, require the applicant to contribute funds, such as some studentships for which the costs are shared between the funder and GCU.
#### Fundings > Split between the collaborative partners > Institutional fEC
## Instruction
This is the cost to GCU of carrying out the project and will typically be a figure from a Costing spreadsheet.
## Example
An application/tender/contract for Contract Research for £10,000 could have a Full Economic Cost of approximately £8,000, and it's this figure that should be entered here. Please refer to the Costing spreadsheet and contact rie.costings@gcu.ac.uk or Susan Armstrong for further advice.
#### Fundings > Split between the collaborative partners > fEC %
## Instruction
"*** To be hidden ***

If unable to be hidden then ""Please leave blank"" could be used."
## Example
n/a
#### Fundings > Split between the collaborative partners > Institutional estimated value
## Instruction
If the funder is offering in-kind support then the cash value for GCU would be noted first, with any in-kind support for partner organisations detailed below. If GCU are showing separately, i.e. as "Glasgow Caledonian University - external organisation", then this should be left blank, as GCUs in-kind support is noted in the first field.
## Example
For example, if a funder is hosting a stakeholder or dissemination meeting and covering the cost of this themselves (room hire and catering etc), then they could consider this an in-kind cost. Each applicant could benefit equally or according to the number of attendees.
#### Deadline
## Instruction
Please state the deadline for submission of the application here.
## Example
If the funder's deadline is 31st July '20 for example, please indicate this here. When considering deadlines, please remember that your application record on PURE requires approval by your Research Advisor or equivalent; RIO; and then Cam, before you should submit the application.
#### Date submitted
## Instruction
This will likely be blank, as applications shouldn't be submitted until fully approved via this process, but RIO will complete this field when applications are submitted by RIO. For applications submitted by the GCU lead academic, or the external PI, the GCU lead should update this field once known. RIO and the Research Advisors will check periodically to ensure this field is completed.
## Example
For Contract Research projects the date entered here will likely be the date the contractual documents are signed, or when bids for tender are made, with RIO populating this field were possible.
#### Funder reply
## Instruction
"This will likely be recorded as ""Pending"", as the result of the application/tender may not be known at the point of entering the application details on PURE. Once the result is known and contract agreed, RIO who will update this to ""Successful"" or ""Unsuccessful"" accordingly.

For Outline applications, if the result is moving on to the next stage, then ""Copy"" the original application to create a new one, amend the details as necessary (e.g. new deadline, new costs, new duration) but keep the same RIO ID. The original record on PURE should now be ""Aborted""."
## Example
Due to the nature of Contract Research projects there may not be an actual submission, in which case an appropriate date will be entered e.g. the date at which the contract is signed by GCU.
#### Exp. start date
## Instruction
Please enter the expected start date of the project, remembering that the start date of the costing and the application should match this date.
## Example
Please enter the start date of the project, taking into account the funder's guidance and requirements e.g. for the CSO, the start date must always be the 1st of a month.
#### Exp. end date
## Instruction
Please enter the expected end date of the project, remembering that the end date of the costing and the application should match this date.
## Example
Please enter the end date of the project, taking into account the funder's guidance and requirements.
#### File title
## Instruction
There will typically be a number of documents to upload as part of an application, such as the PIF; the final costing; a signed risk register; and a copy of the application. The title will default to the name of the document, but feel free to enter a different one.
## Example
For example, you may have had 6 costings done and instead of the title matching the document name you could have "Final Costing" instead of "AMcK Wellcome Trust 01/01/2020 v6 Costing". Neither would be incorrect however.
#### Type
## Instruction
Please choose an applicable document type (or the most appropriate) for the document from the available options.
## Example
For example, if you are uploading the PIF, please choose the "Project Initiation Form (PIF)" type.
#### Web address (URL)
## Instruction
It isn't mandatory but please enter a link to any website you believe appropriate i.e. the funding call.
## Example
For Contract Research there may not be a funding call for example, but a link to the client's website could be entered instead.
#### Description
## Instruction
If a link to a website was entered previously, please note a short description here.
## Example
If the link was to the funding call for example, you could indicate that here.
#### Link type
## Instruction
If a link to a website was entered previously, please select the type of link here.
## Example
If the link was to the funding call for example, you could indicate that here.
#### Related project
## Instruction
If a Project record exists on PURE to which this application relates, then please link to it from here. Project records hold the basic details of Application and Award records, and allow for the grouping of related records. This isn't mandatory though at this point, and records can be linked at a later date.
## Example
For example, Outline application records can be linked to Project records, and so too would the Full Application and subsequent Award records if successful. Project records can also be created to link associated Application and Award records on the basis of Funder or Funding scheme for example.
#### Related applications
## Instruction
If another Application record exists on PURE to which this application relates, then please link to it from here. Typically though, the only other Application record that an Outline Application would be linked to would be the Full version of the application. If an academic wanted to link multiple application records on the basis of funder for example, that would be done by linking to a Project record.
## Example
For example, Outline application records can be linked to Full application records, and subsequent Award records if successful.
#### Award relations
## Instruction
If an Award record exists on PURE to which this application relates, then please link to it from here. Typically though the associated Award record will be created once the application is successful and therefore linked at that time, so linking to an Award at this stage is unlikely to be required.
## Example
n/a
#### Related ethical reviews
## Instruction
This isn't used at present so please ignore.
## Example
n/a
#### Sustainable Development Goals
## Instruction
The SDGs are unlikely to be relevant to Contract Research projects, however feel free to enter these where appropriate and if not please select "Not applicable".
## Example
0
#### Visibility
## Instruction
All application records are confidential, and only if awarded would a further discussion take place for the visibility of Award and Project records.
## Example
"Publicly available - e.g. website/portal
Campus (IP) - from allowed IP-addresses
Restricted to Pure-users - Only visible when logged in to Pure.
Confidential - Only visible when logged into Pure and only for contributors and users with editorial rights to the content"


